<?xml version="1.0" encoding="UTF-8"?>
<xsl:transform xmlns:era="http://www.entitymodelling.org/ERmodel"
               xmlns:xs="http://www.w3.org/2001/XMLSchema"
               xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
               version="2.0"
               xpath-default-namespace="http://www.entitymodelling.org/ERmodel">
   <xsl:output method="xml" indent="yes"/><!-- 
****************************************************************
ERmodel_v1.2/src/ERmodel.functions.fragment.xslt 
****************************************************************

Copyright 2016, 2107 Cyprotex Discovery Ltd.

This file is part of the the ERmodel suite of models and transforms.

The ERmodel suite is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

ERmodel suite is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
****************************************************************
-->

<!--
*************************************
ERmodel.functions.module.xslt
*************************************

DESCRIPTION
  user defined functions for use from other xslts.
  This file is created as a copy of ERmodel.functions.modules.xslt but
  with the root transform commented out. It is used to
  generate fucntion defs into a generated xslt.

CHANGE HISTORY

CR18720 JC  16-Nov-2016 Created
<xsl:transform version="2.0" 
        xmlns="http://www.entitymodelling.org/ERmodel"
        xmlns:xs="http://www.w3.org/2001/XMLSchema"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:era="http://www.entitymodelling.org/ERmodel"
        xmlns:erafn="http://www.entitymodelling.org/ERmodel/functions"
        xpath-default-namespace="http://www.entitymodelling.org/ERmodel">
-->

<!-- Construct a composite key value from individual key values -->
<xsl:function 
     name="era:packArray">
    <xsl:param name="parts" as="xs:string*"/>
    <xsl:value-of select="string-join($parts,':')"/>
</xsl:function>

<xsl:function 
    name="era:packArrayOfNonEmpties">
    <xsl:param name="elements" as="xs:string*"/>
    <xsl:variable name="nonempty_elements" as="xs:string*">
         <xsl:for-each select="$elements">
            <xsl:if test=".!=''">
               <xsl:value-of select="."/>
            </xsl:if>
         </xsl:for-each>
    </xsl:variable>
    <xsl:value-of select="string-join($nonempty_elements,':')"/>
</xsl:function>

<!-- Unpack a packed array -->
<xsl:function 
    name="era:unpackArray">
    <xsl:param name="parray" as="xs:string"/>
    <xsl:sequence select="tokenize($parray,':')"/>
</xsl:function>

<!-- Prefix every element of a packed array -->
<xsl:function 
    name="era:prefixPackedArray">
    <xsl:param name="parray" as="xs:string"/>
    <xsl:param name="prefix" as="xs:string"/>

    <xsl:variable name="elements" as="xs:string*" 
                       select="era:unpackArray($parray)"/>
    <xsl:variable name="prefixedelements" as="xs:string*">
         <xsl:for-each select="$elements">
            <xsl:value-of select="concat($prefix,.)"/>
         </xsl:for-each>
    </xsl:variable>
    <xsl:value-of select="era:packArray($prefixedelements)"/>
</xsl:function>
<!--
</xsl:transform>
-->

<!-- end of file: ERmodel_v1.2/src/ERmodel.functions.fragment.xslt--> 

<xsl:key name="diagram" match="diagram" use="era:packArray(())"/>
   <xsl:key name="defaults" match="defaults" use="era:packArray(())"/>
   <xsl:key name="xml" match="xml" use="era:packArray(())"/>
   <xsl:key name="absolute" match="absolute" use="name"/>
   <xsl:key name="entity_type" match="entity_type" use="name"/>
   <xsl:key name="group" match="group" use="name"/>
   <xsl:key name="entity_type_like" match="entity_type|group" use="name"/>
   <xsl:key name="ENTITY_TYPE" match="absolute|entity_type|group" use="name"/>
   <xsl:key name="attribute"
            match="attribute"
            use="../descendant-or-self::entity_type/concat(name,':',current()/name)"/>
   <xsl:key name="dependency_group"
            match="dependency_group"
            use="era:packArray(())"/>
   <xsl:key name="dependency"
            match="dependency"
            use="../descendant-or-self::entity_type/concat(name,':',current()/name)"/>
   <xsl:key name="reference"
            match="reference"
            use="../descendant-or-self::entity_type/concat(name,':',current()/name)"/>
   <xsl:key name="reference_or_dependency"
            match="dependency|reference"
            use="../descendant-or-self::entity_type/concat(name,':',current()/name)"/>
   <xsl:key name="constructed_relationship"
            match="constructed_relationship"
            use="../descendant-or-self::entity_type/concat(name,':',current()/name)"/>
   <xsl:key name="composition"
            match="composition"
            use="../descendant-or-self::entity_type/concat(name,':',current()/name)"/>
   <xsl:key name="Relationship"
            match="dependency|reference|constructed_relationship|composition"
            use="../descendant-or-self::entity_type/concat(name,':',current()/name)"/>
   <xsl:key name="presentation" match="presentation" use="era:packArray(())"/>
   <xsl:key name="path" match="path" use="era:packArray(())"/>
   <xsl:key name="sequence" match="sequence" use="era:packArray(())"/>
   <xsl:key name="projection" match="projection" use="era:packArray(())"/>
   <xsl:key name="identifying_1"
            match="dependency/identifying|reference/identifying|constructed_relationship/identifying|composition/identifying"
            use="era:packArray(())"/>
   <xsl:key name="inherited" match="inherited" use="era:packArray(())"/>
   <xsl:key name="ZeroOrOne" match="ZeroOrOne" use="era:packArray(())"/>
   <xsl:key name="ExactlyOne" match="ExactlyOne" use="era:packArray(())"/>
   <xsl:key name="ZeroOneOrMore" match="ZeroOneOrMore" use="era:packArray(())"/>
   <xsl:key name="OneOrMore" match="OneOrMore" use="era:packArray(())"/>
   <xsl:key name="cardinality"
            match="ZeroOrOne|ExactlyOne|ZeroOneOrMore|OneOrMore"
            use="era:packArray(())"/>
   <xsl:key name="transient" match="transient" use="era:packArray(())"/>
   <xsl:key name="pullback" match="pullback" use="era:packArray(())"/>
   <xsl:key name="copy" match="copy" use="era:packArray(())"/>
   <xsl:key name="initialiser" match="pullback|copy" use="era:packArray(())"/>
   <xsl:key name="join" match="join" use="era:packArray(())"/>
   <xsl:key name="aggregate" match="aggregate" use="era:packArray(())"/>
   <xsl:key name="complex" match="join|aggregate" use="era:packArray(())"/>
   <xsl:key name="component" match="component" use="era:packArray(())"/>
   <xsl:key name="identity" match="identity" use="era:packArray(())"/>
   <xsl:key name="theabsolute" match="theabsolute" use="era:packArray(())"/>
   <xsl:key name="navigation"
            match="join|aggregate|component|identity|theabsolute"
            use="era:packArray(())"/>
   <xsl:key name="relative" match="relative" use="era:packArray(())"/>
   <xsl:key name="abs" match="abs" use="era:packArray(())"/>
   <xsl:key name="local" match="local" use="era:packArray(())"/>
   <xsl:key name="default" match="default" use="era:packArray(())"/>
   <xsl:key name="position"
            match="relative|abs|local|default"
            use="era:packArray(())"/>
   <xsl:key name="Top" match="Top" use="era:packArray(())"/>
   <xsl:key name="TopLeft" match="TopLeft" use="era:packArray(())"/>
   <xsl:key name="TopRight" match="TopRight" use="era:packArray(())"/>
   <xsl:key name="MiddleRight" match="MiddleRight" use="era:packArray(())"/>
   <xsl:key name="MiddleLeft" match="MiddleLeft" use="era:packArray(())"/>
   <xsl:key name="BottomLeft" match="BottomLeft" use="era:packArray(())"/>
   <xsl:key name="BottomRight" match="BottomRight" use="era:packArray(())"/>
   <xsl:key name="Bottom" match="Bottom" use="era:packArray(())"/>
   <xsl:key name="CustomShape"
            match="Top|TopLeft|TopRight|MiddleRight|MiddleLeft|BottomLeft|BottomRight|Bottom"
            use="era:packArray(())"/>
   <xsl:key name="implementationOf"
            match="implementationOf"
            use="era:packArray(())"/>
   <xsl:key name="boolean" match="boolean" use="era:packArray(())"/>
   <xsl:key name="date" match="date" use="era:packArray(())"/>
   <xsl:key name="dateTime" match="dateTime" use="era:packArray(())"/>
   <xsl:key name="integer" match="integer" use="era:packArray(())"/>
   <xsl:key name="float" match="float" use="era:packArray(())"/>
   <xsl:key name="nonNegativeInteger"
            match="nonNegativeInteger"
            use="era:packArray(())"/>
   <xsl:key name="positiveInteger"
            match="positiveInteger"
            use="era:packArray(())"/>
   <xsl:key name="string" match="string" use="era:packArray(())"/>
   <xsl:key name="time" match="time" use="era:packArray(())"/>
   <xsl:key name="value_type"
            match="boolean|date|dateTime|integer|float|nonNegativeInteger|positiveInteger|string|time"
            use="era:packArray(())"/>
   <xsl:key name="identifying_2"
            match="attribute/identifying"
            use="era:packArray(())"/>
   <xsl:key name="optional" match="optional" use="era:packArray(())"/>
   <xsl:key name="deprecated" match="deprecated" use="era:packArray(())"/>
   <xsl:key name="label" match="label" use="era:packArray(())"/>
   <xsl:key name="ToSrc" match="ToSrc" use="era:packArray(())"/>
   <xsl:key name="ToDest" match="ToDest" use="era:packArray(())"/>
   <xsl:key name="src_or_dest" match="ToSrc|ToDest" use="era:packArray(())"/>
   <xsl:key name="vstep" match="vstep" use="era:packArray(())"/>
   <xsl:key name="hstep" match="hstep" use="era:packArray(())"/>
   <xsl:key name="step" match="vstep|hstep" use="era:packArray(())"/>
   <xsl:key name="reldim" match="reldim" use="era:packArray(())"/>
   <xsl:key name="absdim" match="absdim" use="era:packArray(())"/>
   <xsl:key name="dimension" match="reldim|absdim" use="era:packArray(())"/>
   <xsl:key name="None" match="None" use="era:packArray(())"/>
   <xsl:key name="Split" match="Split" use="era:packArray(())"/>
   <xsl:key name="NoSplit" match="NoSplit" use="era:packArray(())"/>
   <xsl:key name="render" match="None|Split|NoSplit" use="era:packArray(())"/>
   <xsl:key name="Right" match="Right" use="era:packArray(())"/>
   <xsl:key name="Left" match="Left" use="era:packArray(())"/>
   <xsl:key name="Upside" match="Upside" use="era:packArray(())"/>
   <xsl:key name="Downside" match="Downside" use="era:packArray(())"/>
   <xsl:key name="relative_position"
            match="Right|Left|Upside|Downside"
            use="era:packArray(())"/>
   <xsl:key name="Attribute" match="Attribute" use="era:packArray(())"/>
   <xsl:key name="Element_2"
            match="xml/*/Element|attribute/*/Element"
            use="era:packArray(())"/>
   <xsl:key name="Anonymous_2"
            match="xml/*/Anonymous|attribute/*/Anonymous"
            use="era:packArray(())"/>
   <xsl:key name="xmlStyle_2"
            match="Attribute|xml/*/Element|attribute/*/Element|xml/*/Anonymous|attribute/*/Anonymous"
            use="era:packArray(())"/>
   <xsl:key name="Element_1"
            match="entity_type/*/Element"
            use="era:packArray(())"/>
   <xsl:key name="Anonymous_1"
            match="entity_type/*/Anonymous"
            use="era:packArray(())"/>
   <xsl:key name="xmlStyle_1"
            match="entity_type/*/Element|entity_type/*/Anonymous"
            use="era:packArray(())"/>
   <xsl:template match="*" mode="straight_copy">
      <xsl:copy>
         <xsl:apply-templates mode="straight_copy"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template match="/">
      <xsl:variable name="in_filename" select="tokenize(base-uri(),'/')[last()]"/>
      <xsl:variable name="in_filename_wo_extension"
                    select="substring-before($in_filename,'.xml')"/>
      <xsl:variable name="error_filename"
                    select="concat($in_filename_wo_extension,'.errors.xml')"/>
      <xsl:variable name="state">
         <xsl:apply-templates/>
      </xsl:variable>
      <xsl:choose>
         <xsl:when test="boolean($state/descendant-or-self::*:error)">
            <xsl:result-document href="{$error_filename}">
               <xsl:for-each select="$state/*">
                  <xsl:copy>
                     <xsl:apply-templates mode="straight_copy"/>
                  </xsl:copy>
               </xsl:for-each>
            </xsl:result-document>
            <xsl:variable name="errortext"
                          select="string(string-join($state/descendant-or-self::*:error,'-----------------------'))"/>
            <xsl:value-of select="error(QName('http://www.entitymodelling.org/ERmodel', 'ReferentialIntegrityError'),$errortext)"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:for-each select="$state/*">
               <xsl:copy>
                  <xsl:apply-templates mode="straight_copy"/>
               </xsl:copy>
            </xsl:for-each>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template name="wildcard" match="*">
      <xsl:copy>
         <xsl:apply-templates/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="entity_model" match="entity_model">
      <xsl:copy>
         <xsl:apply-templates/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="diagram" match="diagram">
      <xsl:copy>
         <xsl:apply-templates/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="defaults" match="defaults">
      <xsl:copy>
         <xsl:apply-templates/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="xml" match="xml">
      <xsl:copy>
         <xsl:apply-templates/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="ENTITY_TYPE"/>
   <xsl:template name="absolute" match="absolute">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="ENTITY_TYPE"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="entity_type_like">
      <xsl:call-template name="ENTITY_TYPE"/>
   </xsl:template>
   <xsl:template name="entity_type" match="entity_type">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="entity_type_like"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="group" match="group">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="entity_type_like"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="attribute" match="attribute">
      <xsl:copy>
         <xsl:apply-templates/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="dependency_group" match="dependency_group">
      <xsl:copy>
         <xsl:apply-templates/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="Relationship">
      <xsl:if test="type">
         <xsl:variable name="DEST" as="node()*" select="key('ENTITY_TYPE', type)"/>
         <xsl:if test="not($DEST[self::absolute|self::entity_type|self::group])">
            <xsl:variable name="FK" select="type"/>
            <xsl:variable name="MESSAGE">
                    Entity of type Relationship
                              keyed by 
                             <xsl:value-of select="../descendant-or-self::entity_type/concat(name,':',current()/name)"/>
                   has broken reference relationship 'type' of type 'ENTITY_TYPE'
                   ... foreign key '<xsl:value-of select="$FK"/>'
              </xsl:variable>
            <xsl:message>
               <xsl:value-of select="$MESSAGE"/>
            </xsl:message>
            <xsl:element name="error">
               <xsl:value-of select="$MESSAGE"/>
            </xsl:element>
         </xsl:if>
      </xsl:if>
   </xsl:template>
   <xsl:template name="reference_or_dependency">
      <xsl:call-template name="Relationship"/>
   </xsl:template>
   <xsl:template name="dependency" match="dependency">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="reference_or_dependency"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="reference" match="reference">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:variable name="DIAG" as="node()*" select="key('ENTITY_TYPE', type)"/>
         <xsl:if test="$DIAG">
            <xsl:if test="inverse">
               <xsl:variable name="DEST"
                             as="node()*"
                             select="key('reference', concat(key('ENTITY_TYPE', type)/name,':',inverse))"/>
               <xsl:if test="not($DEST[self::reference])">
                  <xsl:variable name="FK" select="concat(key('ENTITY_TYPE', type)/name,':',inverse)"/>
                  <xsl:variable name="MESSAGE">
                    Entity of type reference
                              keyed by 
                             <xsl:value-of select="../descendant-or-self::entity_type/concat(name,':',current()/name)"/>
                   has broken reference relationship 'inverse' of type 'reference'
                   ... foreign key '<xsl:value-of select="$FK"/>'
              </xsl:variable>
                  <xsl:message>
                     <xsl:value-of select="$MESSAGE"/>
                  </xsl:message>
                  <xsl:element name="error">
                     <xsl:value-of select="$MESSAGE"/>
                  </xsl:element>
               </xsl:if>
            </xsl:if>
         </xsl:if>
         <xsl:call-template name="reference_or_dependency"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="constructed_relationship" match="constructed_relationship">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="Relationship"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="composition" match="composition">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="Relationship"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="presentation" match="presentation">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:variable name="DIAG" as="node()*" select="/entity_model"/>
         <xsl:if test="$DIAG">
            <xsl:if test="rightOf">
               <xsl:variable name="DEST" as="node()*" select="key('ENTITY_TYPE', rightOf)"/>
               <xsl:if test="not($DEST[self::absolute|self::entity_type|self::group])">
                  <xsl:variable name="FK" select="rightOf"/>
                  <xsl:variable name="MESSAGE">
                    Entity of type presentation
                              keyed by 
                             <xsl:value-of select="era:packArray(())"/>
                   has broken reference relationship 'rightOf' of type 'ENTITY_TYPE'
                   ... foreign key '<xsl:value-of select="$FK"/>'
              </xsl:variable>
                  <xsl:message>
                     <xsl:value-of select="$MESSAGE"/>
                  </xsl:message>
                  <xsl:element name="error">
                     <xsl:value-of select="$MESSAGE"/>
                  </xsl:element>
               </xsl:if>
            </xsl:if>
         </xsl:if>
         <xsl:variable name="DIAG" as="node()*" select="/entity_model"/>
         <xsl:if test="$DIAG">
            <xsl:if test="below">
               <xsl:variable name="DEST" as="node()*" select="key('ENTITY_TYPE', below)"/>
               <xsl:if test="not($DEST[self::absolute|self::entity_type|self::group])">
                  <xsl:variable name="FK" select="below"/>
                  <xsl:variable name="MESSAGE">
                    Entity of type presentation
                              keyed by 
                             <xsl:value-of select="era:packArray(())"/>
                   has broken reference relationship 'below' of type 'ENTITY_TYPE'
                   ... foreign key '<xsl:value-of select="$FK"/>'
              </xsl:variable>
                  <xsl:message>
                     <xsl:value-of select="$MESSAGE"/>
                  </xsl:message>
                  <xsl:element name="error">
                     <xsl:value-of select="$MESSAGE"/>
                  </xsl:element>
               </xsl:if>
            </xsl:if>
         </xsl:if>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="path" match="path">
      <xsl:copy>
         <xsl:apply-templates/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="sequence" match="sequence">
      <xsl:copy>
         <xsl:apply-templates/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="projection" match="projection">
      <xsl:copy>
         <xsl:apply-templates/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="identifying_1"
                 match="dependency/identifying|reference/identifying|constructed_relationship/identifying|composition/identifying">
      <xsl:copy>
         <xsl:apply-templates/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="inherited" match="inherited">
      <xsl:copy>
         <xsl:apply-templates/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="cardinality"/>
   <xsl:template name="ZeroOrOne" match="ZeroOrOne">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="cardinality"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="ExactlyOne" match="ExactlyOne">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="cardinality"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="ZeroOneOrMore" match="ZeroOneOrMore">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="cardinality"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="OneOrMore" match="OneOrMore">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="cardinality"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="transient" match="transient">
      <xsl:copy>
         <xsl:apply-templates/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="initialiser">
      <xsl:if test="type">
         <xsl:variable name="DEST" as="node()*" select="key('ENTITY_TYPE', type)"/>
         <xsl:if test="not($DEST[self::absolute|self::entity_type|self::group])">
            <xsl:variable name="FK" select="type"/>
            <xsl:variable name="MESSAGE">
                    Entity of type initialiser
                              keyed by 
                             <xsl:value-of select="era:packArray(())"/>
                   has broken reference relationship 'type' of type 'ENTITY_TYPE'
                   ... foreign key '<xsl:value-of select="$FK"/>'
              </xsl:variable>
            <xsl:message>
               <xsl:value-of select="$MESSAGE"/>
            </xsl:message>
            <xsl:element name="error">
               <xsl:value-of select="$MESSAGE"/>
            </xsl:element>
         </xsl:if>
      </xsl:if>
   </xsl:template>
   <xsl:template name="pullback" match="pullback">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:variable name="DIAG" as="node()*" select="../key('ENTITY_TYPE', type)"/>
         <xsl:if test="$DIAG">
            <xsl:if test="projection_rel">
               <xsl:variable name="DEST"
                             as="node()*"
                             select="key('reference', concat(../key('ENTITY_TYPE', type)/name,':',projection_rel))"/>
               <xsl:if test="not($DEST[self::reference])">
                  <xsl:variable name="FK"
                                select="concat(../key('ENTITY_TYPE', type)/name,':',projection_rel)"/>
                  <xsl:variable name="MESSAGE">
                    Entity of type pullback
                              keyed by 
                             <xsl:value-of select="era:packArray(())"/>
                   has broken reference relationship 'projection_rel' of type 'reference'
                   ... foreign key '<xsl:value-of select="$FK"/>'
              </xsl:variable>
                  <xsl:message>
                     <xsl:value-of select="$MESSAGE"/>
                  </xsl:message>
                  <xsl:element name="error">
                     <xsl:value-of select="$MESSAGE"/>
                  </xsl:element>
               </xsl:if>
            </xsl:if>
         </xsl:if>
         <xsl:call-template name="initialiser"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="copy" match="copy">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="initialiser"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="navigation">
      <xsl:if test="src">
         <xsl:variable name="DEST" as="node()*" select="key('ENTITY_TYPE', src)"/>
         <xsl:if test="not($DEST[self::absolute|self::entity_type|self::group])">
            <xsl:variable name="FK" select="src"/>
            <xsl:variable name="MESSAGE">
                    Entity of type navigation
                              keyed by 
                             <xsl:value-of select="era:packArray(())"/>
                   has broken reference relationship 'src' of type 'ENTITY_TYPE'
                   ... foreign key '<xsl:value-of select="$FK"/>'
              </xsl:variable>
            <xsl:message>
               <xsl:value-of select="$MESSAGE"/>
            </xsl:message>
            <xsl:element name="error">
               <xsl:value-of select="$MESSAGE"/>
            </xsl:element>
         </xsl:if>
      </xsl:if>
      <xsl:if test="dest">
         <xsl:variable name="DEST" as="node()*" select="key('ENTITY_TYPE', dest)"/>
         <xsl:if test="not($DEST[self::absolute|self::entity_type|self::group])">
            <xsl:variable name="FK" select="dest"/>
            <xsl:variable name="MESSAGE">
                    Entity of type navigation
                              keyed by 
                             <xsl:value-of select="era:packArray(())"/>
                   has broken reference relationship 'dest' of type 'ENTITY_TYPE'
                   ... foreign key '<xsl:value-of select="$FK"/>'
              </xsl:variable>
            <xsl:message>
               <xsl:value-of select="$MESSAGE"/>
            </xsl:message>
            <xsl:element name="error">
               <xsl:value-of select="$MESSAGE"/>
            </xsl:element>
         </xsl:if>
      </xsl:if>
   </xsl:template>
   <xsl:template name="complex">
      <xsl:call-template name="navigation"/>
   </xsl:template>
   <xsl:template name="join" match="join">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="complex"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="aggregate" match="aggregate">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="complex"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="component" match="component">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:variable name="DIAG" as="node()*" select="key('ENTITY_TYPE', src)"/>
         <xsl:if test="$DIAG">
            <xsl:if test="rel">
               <xsl:variable name="DEST"
                             as="node()*"
                             select="key('Relationship', concat(key('ENTITY_TYPE', src)/name,':',rel))"/>
               <xsl:if test="not($DEST[self::dependency|self::reference|self::constructed_relationship|self::composition])">
                  <xsl:variable name="FK" select="concat(key('ENTITY_TYPE', src)/name,':',rel)"/>
                  <xsl:variable name="MESSAGE">
                    Entity of type component
                              keyed by 
                             <xsl:value-of select="era:packArray(())"/>
                   has broken reference relationship 'rel' of type 'Relationship'
                   ... foreign key '<xsl:value-of select="$FK"/>'
              </xsl:variable>
                  <xsl:message>
                     <xsl:value-of select="$MESSAGE"/>
                  </xsl:message>
                  <xsl:element name="error">
                     <xsl:value-of select="$MESSAGE"/>
                  </xsl:element>
               </xsl:if>
            </xsl:if>
         </xsl:if>
         <xsl:call-template name="navigation"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="position"/>
   <xsl:template name="relative" match="relative">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:variable name="DIAG" as="node()*" select="/entity_model"/>
         <xsl:if test="$DIAG">
            <xsl:if test="to">
               <xsl:variable name="DEST" as="node()*" select="key('ENTITY_TYPE', to)"/>
               <xsl:if test="not($DEST[self::absolute|self::entity_type|self::group])">
                  <xsl:variable name="FK" select="to"/>
                  <xsl:variable name="MESSAGE">
                    Entity of type relative
                              keyed by 
                             <xsl:value-of select="era:packArray(())"/>
                   has broken reference relationship 'to' of type 'ENTITY_TYPE'
                   ... foreign key '<xsl:value-of select="$FK"/>'
              </xsl:variable>
                  <xsl:message>
                     <xsl:value-of select="$MESSAGE"/>
                  </xsl:message>
                  <xsl:element name="error">
                     <xsl:value-of select="$MESSAGE"/>
                  </xsl:element>
               </xsl:if>
            </xsl:if>
         </xsl:if>
         <xsl:call-template name="position"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="abs" match="abs">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="position"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="local" match="local">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="position"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="default" match="default">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="position"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="CustomShape"/>
   <xsl:template name="Top" match="Top">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="CustomShape"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="TopLeft" match="TopLeft">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="CustomShape"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="TopRight" match="TopRight">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="CustomShape"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="MiddleRight" match="MiddleRight">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="CustomShape"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="MiddleLeft" match="MiddleLeft">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="CustomShape"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="BottomLeft" match="BottomLeft">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="CustomShape"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="BottomRight" match="BottomRight">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="CustomShape"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="Bottom" match="Bottom">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="CustomShape"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="implementationOf" match="implementationOf">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:variable name="DIAG"
                       as="node()*"
                       select="key('reference_or_dependency', concat(../../name,':',rel))/key('ENTITY_TYPE', type)"/>
         <xsl:if test="$DIAG">
            <xsl:if test="destattr">
               <xsl:variable name="DEST"
                             as="node()*"
                             select="key('attribute', concat(key('reference_or_dependency', concat(../../name,':',rel))/key('ENTITY_TYPE', type)/name,':',destattr))"/>
               <xsl:if test="not($DEST[self::attribute])">
                  <xsl:variable name="FK"
                                select="concat(key('reference_or_dependency', concat(../../name,':',rel))/key('ENTITY_TYPE', type)/name,':',destattr)"/>
                  <xsl:variable name="MESSAGE">
                    Entity of type implementationOf
                              keyed by 
                             <xsl:value-of select="era:packArray(())"/>
                   has broken reference relationship 'destattr' of type 'attribute'
                   ... foreign key '<xsl:value-of select="$FK"/>'
              </xsl:variable>
                  <xsl:message>
                     <xsl:value-of select="$MESSAGE"/>
                  </xsl:message>
                  <xsl:element name="error">
                     <xsl:value-of select="$MESSAGE"/>
                  </xsl:element>
               </xsl:if>
            </xsl:if>
         </xsl:if>
         <xsl:variable name="DIAG" as="node()*" select="key('ENTITY_TYPE', typeOfOrigin)"/>
         <xsl:if test="$DIAG">
            <xsl:if test="attrOfOrigin">
               <xsl:variable name="DEST"
                             as="node()*"
                             select="key('attribute', concat(key('ENTITY_TYPE', typeOfOrigin)/name,':',attrOfOrigin))"/>
               <xsl:if test="not($DEST[self::attribute])">
                  <xsl:variable name="FK"
                                select="concat(key('ENTITY_TYPE', typeOfOrigin)/name,':',attrOfOrigin)"/>
                  <xsl:variable name="MESSAGE">
                    Entity of type implementationOf
                              keyed by 
                             <xsl:value-of select="era:packArray(())"/>
                   has broken reference relationship 'attrOfOrigin' of type 'attribute'
                   ... foreign key '<xsl:value-of select="$FK"/>'
              </xsl:variable>
                  <xsl:message>
                     <xsl:value-of select="$MESSAGE"/>
                  </xsl:message>
                  <xsl:element name="error">
                     <xsl:value-of select="$MESSAGE"/>
                  </xsl:element>
               </xsl:if>
            </xsl:if>
         </xsl:if>
         <xsl:variable name="DIAG" as="node()*" select="/entity_model"/>
         <xsl:if test="$DIAG">
            <xsl:if test="typeOfOrigin">
               <xsl:variable name="DEST" as="node()*" select="key('ENTITY_TYPE', typeOfOrigin)"/>
               <xsl:if test="not($DEST[self::absolute|self::entity_type|self::group])">
                  <xsl:variable name="FK" select="typeOfOrigin"/>
                  <xsl:variable name="MESSAGE">
                    Entity of type implementationOf
                              keyed by 
                             <xsl:value-of select="era:packArray(())"/>
                   has broken reference relationship 'typeOfOrigin' of type 'ENTITY_TYPE'
                   ... foreign key '<xsl:value-of select="$FK"/>'
              </xsl:variable>
                  <xsl:message>
                     <xsl:value-of select="$MESSAGE"/>
                  </xsl:message>
                  <xsl:element name="error">
                     <xsl:value-of select="$MESSAGE"/>
                  </xsl:element>
               </xsl:if>
            </xsl:if>
         </xsl:if>
         <xsl:variable name="DIAG" as="node()*" select="../.."/>
         <xsl:if test="$DIAG">
            <xsl:if test="rel">
               <xsl:variable name="DEST"
                             as="node()*"
                             select="key('reference_or_dependency', concat(../../name,':',rel))"/>
               <xsl:if test="not($DEST[self::dependency|self::reference])">
                  <xsl:variable name="FK" select="concat(../../name,':',rel)"/>
                  <xsl:variable name="MESSAGE">
                    Entity of type implementationOf
                              keyed by 
                             <xsl:value-of select="era:packArray(())"/>
                   has broken reference relationship 'rel' of type 'reference_or_dependency'
                   ... foreign key '<xsl:value-of select="$FK"/>'
              </xsl:variable>
                  <xsl:message>
                     <xsl:value-of select="$MESSAGE"/>
                  </xsl:message>
                  <xsl:element name="error">
                     <xsl:value-of select="$MESSAGE"/>
                  </xsl:element>
               </xsl:if>
            </xsl:if>
         </xsl:if>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="value_type"/>
   <xsl:template name="boolean" match="boolean">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="value_type"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="date" match="date">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="value_type"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="dateTime" match="dateTime">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="value_type"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="integer" match="integer">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="value_type"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="float" match="float">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="value_type"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="nonNegativeInteger" match="nonNegativeInteger">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="value_type"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="positiveInteger" match="positiveInteger">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="value_type"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="string" match="string">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="value_type"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="time" match="time">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="value_type"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="identifying_2" match="attribute/identifying">
      <xsl:copy>
         <xsl:apply-templates/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="optional" match="optional">
      <xsl:copy>
         <xsl:apply-templates/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="deprecated" match="deprecated">
      <xsl:copy>
         <xsl:apply-templates/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="label" match="label">
      <xsl:copy>
         <xsl:apply-templates/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="src_or_dest"/>
   <xsl:template name="ToSrc" match="ToSrc">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="src_or_dest"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="ToDest" match="ToDest">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="src_or_dest"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="step"/>
   <xsl:template name="vstep" match="vstep">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="step"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="hstep" match="hstep">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="step"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="dimension"/>
   <xsl:template name="reldim" match="reldim">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="dimension"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="absdim" match="absdim">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="dimension"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="render"/>
   <xsl:template name="None" match="None">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="render"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="Split" match="Split">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="render"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="NoSplit" match="NoSplit">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="render"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="relative_position"/>
   <xsl:template name="Right" match="Right">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="relative_position"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="Left" match="Left">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="relative_position"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="Upside" match="Upside">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="relative_position"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="Downside" match="Downside">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="relative_position"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="xmlStyle_2"/>
   <xsl:template name="Attribute" match="Attribute">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="xmlStyle_2"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="Element_2" match="xml/*/Element|attribute/*/Element">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="xmlStyle_2"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="Anonymous_2" match="xml/*/Anonymous|attribute/*/Anonymous">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="xmlStyle_2"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="xmlStyle_1"/>
   <xsl:template name="Element_1" match="entity_type/*/Element">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="xmlStyle_1"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template name="Anonymous_1" match="entity_type/*/Anonymous">
      <xsl:copy>
         <xsl:apply-templates/>
         <xsl:call-template name="xmlStyle_1"/>
      </xsl:copy>
   </xsl:template>
</xsl:transform>
