<?xml version="1.0" encoding="UTF-8"?>
<xsl:transform xmlns:era="http://www.entitymodelling.org/ERmodel"
               xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
               version="2.0"
               xpath-default-namespace="http://www.entitymodelling.org/ERmodel">
   <xsl:output method="xml" indent="yes"/>
   <xsl:include href="ERmodel.functions.module.xslt"/>
   <xsl:key name="diagram" match="diagram" use="era:packArray(())"/>
   <xsl:key name="defaults" match="defaults" use="era:packArray(())"/>
   <xsl:key name="xml" match="xml" use="era:packArray(())"/>
   <xsl:key name="absolute" match="absolute" use="name"/>
   <xsl:key name="entity_type" match="entity_type" use="name"/>
   <xsl:key name="group" match="group" use="name"/>
   <xsl:key name="entity_type_like" match="entity_type|group" use="name"/>
   <xsl:key name="ENTITY_TYPE" match="absolute|entity_type|group" use="name"/>
   <xsl:key name="attribute"
            match="attribute"
            use="../descendant-or-self::entity_type/concat(name,':',current()/name)"/>
   <xsl:key name="dependency_group"
            match="dependency_group"
            use="era:packArray(())"/>
   <xsl:key name="dependency"
            match="dependency"
            use="../descendant-or-self::entity_type/concat(name,':',current()/name)"/>
   <xsl:key name="reference"
            match="reference"
            use="../descendant-or-self::entity_type/concat(name,':',current()/name)"/>
   <xsl:key name="reference_or_dependency"
            match="dependency|reference"
            use="../descendant-or-self::entity_type/concat(name,':',current()/name)"/>
   <xsl:key name="constructed_relationship"
            match="constructed_relationship"
            use="../descendant-or-self::entity_type/concat(name,':',current()/name)"/>
   <xsl:key name="composition"
            match="composition"
            use="../descendant-or-self::entity_type/concat(name,':',current()/name)"/>
   <xsl:key name="Relationship"
            match="dependency|reference|constructed_relationship|composition"
            use="../descendant-or-self::entity_type/concat(name,':',current()/name)"/>
   <xsl:key name="presentation" match="presentation" use="era:packArray(())"/>
   <xsl:key name="path" match="path" use="era:packArray(())"/>
   <xsl:key name="sequence" match="sequence" use="era:packArray(())"/>
   <xsl:key name="projection" match="projection" use="era:packArray(())"/>
   <xsl:key name="identifying_1"
            match="dependency/identifying|reference/identifying|constructed_relationship/identifying|composition/identifying"
            use="era:packArray(())"/>
   <xsl:key name="inherited" match="inherited" use="era:packArray(())"/>
   <xsl:key name="ZeroOrOne" match="ZeroOrOne" use="era:packArray(())"/>
   <xsl:key name="ExactlyOne" match="ExactlyOne" use="era:packArray(())"/>
   <xsl:key name="ZeroOneOrMore" match="ZeroOneOrMore" use="era:packArray(())"/>
   <xsl:key name="OneOrMore" match="OneOrMore" use="era:packArray(())"/>
   <xsl:key name="cardinality"
            match="ZeroOrOne|ExactlyOne|ZeroOneOrMore|OneOrMore"
            use="era:packArray(())"/>
   <xsl:key name="transient" match="transient" use="era:packArray(())"/>
   <xsl:key name="pullback" match="pullback" use="era:packArray(())"/>
   <xsl:key name="copy" match="copy" use="era:packArray(())"/>
   <xsl:key name="initialiser" match="pullback|copy" use="era:packArray(())"/>
   <xsl:key name="join" match="join" use="era:packArray(())"/>
   <xsl:key name="aggregate" match="aggregate" use="era:packArray(())"/>
   <xsl:key name="complex" match="join|aggregate" use="era:packArray(())"/>
   <xsl:key name="component" match="component" use="era:packArray(())"/>
   <xsl:key name="identity" match="identity" use="era:packArray(())"/>
   <xsl:key name="theabsolute" match="theabsolute" use="era:packArray(())"/>
   <xsl:key name="navigation"
            match="join|aggregate|component|identity|theabsolute"
            use="era:packArray(())"/>
   <xsl:key name="relative" match="relative" use="era:packArray(())"/>
   <xsl:key name="abs" match="abs" use="era:packArray(())"/>
   <xsl:key name="local" match="local" use="era:packArray(())"/>
   <xsl:key name="default" match="default" use="era:packArray(())"/>
   <xsl:key name="position"
            match="relative|abs|local|default"
            use="era:packArray(())"/>
   <xsl:key name="Top" match="Top" use="era:packArray(())"/>
   <xsl:key name="TopLeft" match="TopLeft" use="era:packArray(())"/>
   <xsl:key name="TopRight" match="TopRight" use="era:packArray(())"/>
   <xsl:key name="MiddleRight" match="MiddleRight" use="era:packArray(())"/>
   <xsl:key name="MiddleLeft" match="MiddleLeft" use="era:packArray(())"/>
   <xsl:key name="BottomLeft" match="BottomLeft" use="era:packArray(())"/>
   <xsl:key name="BottomRight" match="BottomRight" use="era:packArray(())"/>
   <xsl:key name="Bottom" match="Bottom" use="era:packArray(())"/>
   <xsl:key name="CustomShape"
            match="Top|TopLeft|TopRight|MiddleRight|MiddleLeft|BottomLeft|BottomRight|Bottom"
            use="era:packArray(())"/>
   <xsl:key name="implementationOf"
            match="implementationOf"
            use="era:packArray(())"/>
   <xsl:key name="boolean" match="boolean" use="era:packArray(())"/>
   <xsl:key name="date" match="date" use="era:packArray(())"/>
   <xsl:key name="dateTime" match="dateTime" use="era:packArray(())"/>
   <xsl:key name="integer" match="integer" use="era:packArray(())"/>
   <xsl:key name="float" match="float" use="era:packArray(())"/>
   <xsl:key name="nonNegativeInteger"
            match="nonNegativeInteger"
            use="era:packArray(())"/>
   <xsl:key name="positiveInteger"
            match="positiveInteger"
            use="era:packArray(())"/>
   <xsl:key name="string" match="string" use="era:packArray(())"/>
   <xsl:key name="time" match="time" use="era:packArray(())"/>
   <xsl:key name="value_type"
            match="boolean|date|dateTime|integer|float|nonNegativeInteger|positiveInteger|string|time"
            use="era:packArray(())"/>
   <xsl:key name="identifying_2"
            match="attribute/identifying"
            use="era:packArray(())"/>
   <xsl:key name="optional" match="optional" use="era:packArray(())"/>
   <xsl:key name="deprecated" match="deprecated" use="era:packArray(())"/>
   <xsl:key name="label" match="label" use="era:packArray(())"/>
   <xsl:key name="ToSrc" match="ToSrc" use="era:packArray(())"/>
   <xsl:key name="ToDest" match="ToDest" use="era:packArray(())"/>
   <xsl:key name="src_or_dest" match="ToSrc|ToDest" use="era:packArray(())"/>
   <xsl:key name="vstep" match="vstep" use="era:packArray(())"/>
   <xsl:key name="hstep" match="hstep" use="era:packArray(())"/>
   <xsl:key name="step" match="vstep|hstep" use="era:packArray(())"/>
   <xsl:key name="reldim" match="reldim" use="era:packArray(())"/>
   <xsl:key name="absdim" match="absdim" use="era:packArray(())"/>
   <xsl:key name="dimension" match="reldim|absdim" use="era:packArray(())"/>
   <xsl:key name="None" match="None" use="era:packArray(())"/>
   <xsl:key name="Split" match="Split" use="era:packArray(())"/>
   <xsl:key name="NoSplit" match="NoSplit" use="era:packArray(())"/>
   <xsl:key name="render" match="None|Split|NoSplit" use="era:packArray(())"/>
   <xsl:key name="Right" match="Right" use="era:packArray(())"/>
   <xsl:key name="Left" match="Left" use="era:packArray(())"/>
   <xsl:key name="Upside" match="Upside" use="era:packArray(())"/>
   <xsl:key name="Downside" match="Downside" use="era:packArray(())"/>
   <xsl:key name="relative_position"
            match="Right|Left|Upside|Downside"
            use="era:packArray(())"/>
   <xsl:key name="Attribute" match="Attribute" use="era:packArray(())"/>
   <xsl:key name="Element_2"
            match="xml/*/Element|attribute/*/Element"
            use="era:packArray(())"/>
   <xsl:key name="Anonymous_2"
            match="xml/*/Anonymous|attribute/*/Anonymous"
            use="era:packArray(())"/>
   <xsl:key name="xmlStyle_2"
            match="Attribute|xml/*/Element|attribute/*/Element|xml/*/Anonymous|attribute/*/Anonymous"
            use="era:packArray(())"/>
   <xsl:key name="Element_1"
            match="entity_type/*/Element"
            use="era:packArray(())"/>
   <xsl:key name="Anonymous_1"
            match="entity_type/*/Anonymous"
            use="era:packArray(())"/>
   <xsl:key name="xmlStyle_1"
            match="entity_type/*/Element|entity_type/*/Anonymous"
            use="era:packArray(())"/>
   <xsl:template match="/">
      <xsl:copy>
         <xsl:apply-templates mode="pass_0"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template match="@*|node()" mode="pass_0">
      <xsl:copy>
         <xsl:apply-templates select="@*|node()" mode="pass_0"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template match="@*|node()">
      <xsl:copy>
         <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template match="include[not(*/self::type)]" mode="pass_0">
      <xsl:apply-templates select="document(filename)/*/*" mode="pass_0"/>
   </xsl:template>
   <xsl:template match="/*/include[*/self::type]" mode="pass_0">
      <xsl:variable name="temp" select="../name()"/>
      <xsl:apply-templates select="document(filename)/*[name()=$temp]/*[name()=current()/type]"
                           mode="pass_0"/>
   </xsl:template>
   <xsl:template match="/*/*/include[*/self::type]" mode="pass_0">
      <xsl:variable name="temp" select="../../name()"/>
      <xsl:variable name="temp2" select="../name()"/>
      <xsl:apply-templates select="document(filename)/*[name()=$temp]/*[name()=$temp2]/*[name()=current()/type]"
                           mode="pass_0"/>
   </xsl:template>
</xsl:transform>
