/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.SimpleCollation;
import net.sf.saxon.functions.CollatingFunctionFixed;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.SubstringMatcher;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;

public class Contains
extends CollatingFunctionFixed {
    public Expression makeOptimizedFunctionCall(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo, Expression ... arguments) throws XPathException {
        if (this.getStringCollator() == CodepointCollator.getInstance()) {
            return new SystemFunctionCall(this, arguments){

                public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
                    String s0 = this.getArg(0).evaluateAsString(context).toString();
                    String s1 = this.getArg(1).evaluateAsString(context).toString();
                    return s0.contains(s1);
                }

                public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
                    return this;
                }
            };
        }
        return super.makeOptimizedFunctionCall(visitor, contextInfo, arguments);
    }

    private static boolean contains(StringValue arg0, StringValue arg1, StringCollator collator) throws XPathException {
        if (arg1 == null || arg1.isZeroLength() || collator.comparesEqual(arg1.getPrimitiveStringValue(), "")) {
            return true;
        }
        if (arg0 == null || arg0.isZeroLength()) {
            return false;
        }
        String s0 = arg0.getStringValue();
        String s1 = arg1.getStringValue();
        if (collator instanceof CodepointCollator) {
            return s0.indexOf(s1, 0) >= 0;
        }
        if (collator instanceof SimpleCollation) {
            collator = ((SimpleCollation)collator).getSubstringMatcher();
        }
        if (collator instanceof SubstringMatcher) {
            return ((SubstringMatcher)collator).contains(s0, s1);
        }
        throw new XPathException("The collation requested for fn:contains does not support substring matching", "FOCH0004");
    }

    public BooleanValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue s0 = (StringValue)arguments[0].head();
        StringValue s1 = (StringValue)arguments[1].head();
        return BooleanValue.get(Contains.contains(s0, s1, this.getStringCollator()));
    }
}

